﻿using System;

namespace Magify
{
    public class BaseAnalyticsService : IDisposable
    {
        /// <summary>
        /// By design, it should only be used for debugging and testing.
        /// </summary>
        public void TweakAnalyticsConfig(int eventsGroupSize, int syncTimeInterval)
        {
            MagifyManager.TweakAnalyticsConfig(eventsGroupSize, syncTimeInterval);
        }

        /// <summary>
        /// By design, it should only be used for debugging and testing.
        /// </summary>
        public void ResetAnalyticsConfig()
        {
            MagifyManager.ResetAnalyticsConfig();
        }

        /// <summary>
        /// By design, it should only be used for debugging and testing.
        /// </summary>
        public void TweakUserLocale(string languageTag)
        {
            MagifyManager.TweakUserLocale(languageTag);
            MagifyManager.ResetAndForceUpdate();
        }

        void IDisposable.Dispose()
        {
            // TODO release managed resources here
        }
    }
}