using System.Collections.Generic;

namespace Magify
{
    public class CreativePopup : Popup<CreativePopup.Args>
    {
        public class Args : PopupArgs
        {
            public string Event { get; }
            public string CampaignName { get; }
            public CustomCreative Creative { get; }
            public IReadOnlyList<ProductDef> Products { get; }
            public LtoInfo Offer { get; }

            public Args(string @event, string campaignName, CustomCreative creative, IReadOnlyList<ProductDef> products, LtoInfo offer)
                : base(creative.Attributes)
            {
                Event = @event;
                CampaignName = campaignName;
                Products = products;
                Creative = creative;
                Offer = offer;
            }
        }
    }
}