using System.Threading;
using Cysharp.Threading.Tasks;

namespace Magify
{
    public interface IPopupsProvider
    {
        public void UnloadPopup<TArgs>(IPopupBase<TArgs> panel)
            where TArgs : PopupArgs;

        public UniTask<IPopup<PopupArgs>> LoadPopup(string screenId, CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopup<PopupArgs>)null);
        }

        public UniTask<IPopupWithProducts<CreativePopup.Args>> LoadCreativeWithProductsPopup(string screenId, CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopupWithProducts<CreativePopup.Args>)null);
        }

        public UniTask<IPopupBase<PopupArgs>> LoadSpinner(CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopupBase<PopupArgs>)null);
        }

        public UniTask<IPopup<ImagePopup.Args>> LoadImagePopup(CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopup<ImagePopup.Args>)null);
        }

        public UniTask<IPopup<ImagePopup.Args>> LoadFullscreenPopup(CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopup<ImagePopup.Args>)null);
        }

        public UniTask<IPopup<PopupArgs>> LoadRateReviewPopup(CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopup<PopupArgs>)null);
        }

        public UniTask<IPopupBase<PopupArgs>> LoadInterPopupSplash(CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopupBase<PopupArgs>)null);
        }

        public UniTask<IPopup<ErrorPopup.Args>> LoadErrorPopup(CancellationToken cancellationToken)
        {
            return UniTask.FromResult((IPopup<ErrorPopup.Args>)null);
        }
    }
}