﻿namespace Magify
{
    public interface IMinimalInAppStore
    {
        /// <summary>
        /// You should invoke this event when purchase is finished.
        /// </summary>
        event PurchaseFinishedDelegate OnPurchaseFinished;

        /// <summary>
        /// Must return information about current active subscription if exist.
        /// </summary>
        /// <returns>
        /// You should return information about current active subscription. <br/>
        /// You should return null if subscription is expired.
        /// </returns>
        /// <remarks>
        /// You can use <see cref="UnityPurchasesUtils.LoadSubscriptionInfo"/> to load subscription info if you use Unity Purchasing.
        /// </remarks>
        SubscriptionInfo LoadSubscriptionInfo(string productId);
    }
}