﻿using System.Threading;
using Cysharp.Threading.Tasks;

namespace Magify
{
    public interface ICampaignHandler
    {
        public bool CanHandleCampaign(CampaignRequest request);
        public UniTask<CampaignResult> HandleCampaignAsync(CampaignRequest request, CancellationToken cancellationToken);
    }

    public abstract class CampaignHandler<T> : ICampaignHandler
        where T : ICampaign
    {
        public bool CanHandleCampaign(CampaignRequest request)
        {
            return request.Campaign is T typed && CanHandleCampaign(request, typed);
        }

        protected virtual bool CanHandleCampaign(CampaignRequest request, T campaign) => true;

        public abstract UniTask<CampaignResult> HandleCampaignAsync(CampaignRequest request, CancellationToken cancellationToken);
    }
}