using System.Threading;
using Cysharp.Threading.Tasks;
using UnityEngine;

namespace Magify
{
    internal abstract class InterstitialCampaignHandler : ICampaignHandler
    {
        private static readonly MagifyLogger _logger = MagifyLogger.Get(MagifyService.LogScope);

        protected readonly AdvertiserService Advertiser;

        protected InterstitialCampaignHandler(AdvertiserService advertiser)
        {
            Advertiser = advertiser;
        }

        public abstract bool CanHandleCampaign(CampaignRequest request);
        public abstract UniTask<CampaignResult> HandleCampaignAsync(CampaignRequest request, CancellationToken cancellationToken);

        protected async UniTask<CampaignResult> ShowIterVideoAd(CampaignRequest request)
        {
            _logger.Log("InterVideo - show and wait for result");
            var result = await Advertiser.ShowInterVideoAsync(
                request.Event,
                impression =>
                {
                    _logger.Log($"InterVideo - TrackClickFor: {nameof(impression)}={JsonFacade.SerializeObject(impression)}");
                    request.TrackAdsClick();
                }
            );

            _logger.Log($"InterVideo show result: {result.State}");
            if (result.State == AdShowState.Showed)
            {
                _logger.Log($"InterVideo - TrackAdsImpression: {nameof(result.Impression)}={JsonFacade.SerializeObject(result.Impression)}");
                request.TrackAdsShow(result.Impression);
            }
            else
            {
                _logger.Log($"InterVideo - TrackImpressionFail. FailType={result.State}. Error: {result.Error}");
                request.TrackShowFailed($"FailType={result.State}. Error: {result.Error}");
            }

            return result.State is AdShowState.Showed or AdShowState.Closed ? CampaignResult.Applied : CampaignResult.Failed;
        }
    }
}