namespace Magify
{
    public struct AdShowResult
    {
        public static AdShowResult Showed(IAdsImpression impression) => new() { State = AdShowState.Showed, Impression = impression};
        public static AdShowResult NotReady() => new() { State = AdShowState.NotReady, Error = "Ads mediator is not ready yet" };
        public static AdShowResult MediatorError(string mediatorMessage) => new() { State = AdShowState.Error, Error = mediatorMessage };
        public static AdShowResult UserCanceled() => new() { State = AdShowState.Closed, Error = "Ad canceled by user" };

        public static AdShowResult Unexpected(string message)
        {
            return new AdShowResult() { State = AdShowState.Unexpected, Error = message };
        }

        public AdShowState State;
        public string Error;
        public IAdsImpression Impression;

        public override string ToString()
        {
            return $"{State}; Error={Error};";
        }
    }

    public enum AdShowState
    {
        NotReady,
        Error,
        Unexpected,

        Showed,
        Closed
    }
}