using UnityEngine;

namespace Magify.PlayerBuilder
{
    public static partial class MagifyBuildUtilities
    {
        /// <summary>
        /// Adds all cross-promo packages to AndroidManifest. Works only for Android build.
        /// </summary>
        /// <param name="manifestPath">The path to AndroidManifest.xml.</param>
        public static void UpdateManifest(string manifestPath)
        {
            UpdateManifestPartial(manifestPath);
        }

        /// <summary>
        /// Adds all cross-promo packages to Info.plist. Works only for iOS build.
        /// </summary>
        /// <param name="plistPath">The path to Info.plist.</param>
        public static void UpdatePlist(string plistPath)
        {
            UpdatePlistPartial(plistPath);
        }

        static partial void UpdateManifestPartial(string manifestPath);
        static partial void UpdatePlistPartial(string plistPath);

        private static void Log(string message)
        {
            Debug.Log($"[MagifyBuildProcessor]: {message}");
        }
    }
}