using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace Magify.PlayerBuilder
{
    public partial class MagifyBuildConfig : ScriptableObject
    {
        [SerializeField]
        private bool _autoPatchManifestOnBuild = true;
        [SerializeField]
        private bool _autoPatchPlistOnBuild = true;
        [SerializeField]
        private int _postprocessorsCallbackOrder = 2;
        [SerializeField]
        private List<BundleInfo> _androidCrossPromoPackages = new List<BundleInfo>();
        [SerializeField]
        private List<BundleInfo> _iosCrossPromoSchemas = new List<BundleInfo>();

        public static int PostprocessorsCallbackOrder
        {
            get => GetInstance()._postprocessorsCallbackOrder;
            set => GetInstance()._postprocessorsCallbackOrder = value;
        }

        public static bool AutoPatchManifestOnBuild
        {
            get => GetInstance()._autoPatchManifestOnBuild;
            set => GetInstance()._autoPatchManifestOnBuild = value;
        }

        public static bool AutoPatchPlistOnBuild
        {
            get => GetInstance()._autoPatchPlistOnBuild;
            set => GetInstance()._autoPatchPlistOnBuild = value;
        }

        public static List<BundleInfo> AndroidCrossPromoPackages => GetInstance()._androidCrossPromoPackages;

        public static List<BundleInfo> IOSCrossPromoSchemas => GetInstance()._iosCrossPromoSchemas;

        public static HashSet<string> GetAllAndroidPackages()
        {
            var packages = new HashSet<string>(AndroidCrossPromoPackages.Select(c => c.Id));
            return packages;
        }

        public static HashSet<string> GetAllIOSAppSchemas()
        {
            var packages = new HashSet<string>(IOSCrossPromoSchemas.Select(c => c.Id));
            return packages;
        }
    }
}