﻿using System.Collections.Generic;
using TMPro;
using UnityEngine;

namespace Magify
{
    public interface ILocalizationEditorHelper
    {
        string GetCurrentLocale();
        void LocalizeText(TMP_Text tmpText);
        string GetLocalizedCacheCharacters(TMP_Text tmpText, bool isUpperOrLowerCase, List<string> availableLocales, bool includeAllLanguages);
        Dictionary<string, string> GetLocalizationStringForPreparing(TMP_Text tmp, List<string> availableLocales, bool includeAllLanguages);
        string GetCharactersForPreparing(TMP_Text tmp, List<string> availableLocales, bool includeAllLanguages);
        void RemoveLocalizationScripts(GameObject editingScopePrefabContentsRoot);
        void SetCurrentLocale(string localeCode);
    }
}