using System.IO;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify.Tests
{
    public static class EditorModeTestsEnvironment
    {
        public static readonly EndpointUrl DefaultEndpoint = EndpointUrl.Staging;
        public static readonly EndpointUrl OfflineEndpoint = EndpointUrl.Offline;
        [NotNull]
        public const string AppName = "AppName";
        [NotNull]
        public const string AppVersion = "1.0.0";
        [NotNull]
        public static readonly string RootStoragePath = Path.Combine(Application.temporaryCachePath, PackageInfo.FolderName);
        [NotNull]
        public static readonly string TempStoragePath = Path.Combine(RootStoragePath, "test.bin");
        [NotNull]
        public static readonly string GeneralPrefsPath = Path.Combine(RootStoragePath, IMagifyClient.GeneralPrefsName);
        [NotNull]
        public static readonly string InternalConfigPrefsPath = Path.Combine(RootStoragePath, IMagifyClient.InternalConfigPrefsName);
        [NotNull]
        public static readonly string AppStatePrefsPath = Path.Combine(RootStoragePath, IMagifyClient.AppStatePrefsName);
        [NotNull]
        public static readonly string LocalGeneralPrefsPath = Path.Combine(RootStoragePath, IMagifyClient.LocalGeneralPrefsName);
        [NotNull]
        public static readonly string OffersPrefsName = Path.Combine(RootStoragePath, IMagifyClient.OffersPrefsName);
        [NotNull]
        public static readonly string CountersFolderPath = Path.Combine(RootStoragePath, IMagifyClient.CountersFolderName);
        [NotNull]
        public static readonly string ClientStatePath = Path.Combine(RootStoragePath, "client_state.txt");
        [NotNull]
        public static readonly string StoredAppFeaturesFolderPath = Path.Combine(RootStoragePath, StoredAppFeaturesRemoteStorage.RootFolderName);
        [NotNull]
        public static readonly ClientStateConfig DefaultClientStateConfig = new();

        public static void Clear()
        {
            if (Directory.Exists(RootStoragePath))
            {
                Directory.Delete(RootStoragePath, true);
            }
        }
    }
}