using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class Dispose : MagifyClientTestsPart
        {
            [Test]
            [UnitTestTarget(typeof(MagifyClient), nameof(MagifyClient.Dispose))]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void Create_Dispose_Recreate(ClientKind kind)
            {
                using (CreateDefault(kind))
                {
                }
                using (CreateDefault(kind))
                {
                }
            }

            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void Create_Initialize_Dispose_Recreate(ClientKind kind)
            {
                using (var client = CreateDefault(kind))
                {
                    client.InitializeSdk();
                }
                using (CreateDefault(kind))
                {
                }
            }

            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void Create_Initialize_Dispose_Recreate_Initialize(ClientKind kind)
            {
                using (var client = CreateDefault(kind))
                {
                    client.InitializeSdk();
                }
                using (var client = CreateDefault(kind))
                {
                    client.InitializeSdk();
                }
            }

            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void Create_InitializeSetup_Dispose_Recreate(ClientKind kind)
            {
                using (CreateDefaultAndInit(kind))
                {
                }
                using (CreateDefault(kind))
                {
                }
            }

            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void Create_InitializeSetup_Dispose_Recreate_InitializeSetup(ClientKind kind)
            {
                using (CreateDefaultAndInit(kind))
                {
                }
                using (CreateDefaultAndInit(kind))
                {
                }
            }

            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void Create_InitializeSetup_Dispose_ClearAllData_Recreate_InitializeSetup(ClientKind kind)
            {
                using (CreateDefaultAndInit(kind))
                {
                }
                EditorModeTestsEnvironment.Clear();
                using (CreateDefaultAndInit(kind))
                {
                }
            }
        }
    }
}