﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace Magify
{
    [AddComponentMenu("")] // hides this component from "Add Component" menu in inspector
    [RequireComponent(typeof(Canvas))]
    internal class CanvasSafeArea : MonoBehaviour
    {
        private Canvas _canvas;
        private Transform _transform;
        private readonly List<RectTransform> _children = new List<RectTransform>();

        private void Awake()
        {
            RecalculateAll();
        }

        private void OnRectTransformDimensionsChange()
        {
            RecalculateAll();
        }

        public void RecalculateAll()
        {
            _canvas ??= GetComponent<Canvas>();
            _transform ??= GetComponent<Transform>();
            
            _children.Clear();
            foreach (var child in _transform.GetComponentsInChildren<RectTransform>(true).Where(c => c.name.StartsWith("SafeArea")))
            {
                _children.Add(child);
            }

            var area = Screen.safeArea;
            foreach (var child in _children)
            {
                ApplySafeArea(area, child);
            }
        }

        private void ApplySafeArea(Rect safeArea, RectTransform rect)
        {
            var anchorMin = safeArea.position;
            var anchorMax = safeArea.position + safeArea.size;
            var pixelRect = _canvas.pixelRect;
            anchorMin.x /= pixelRect.width;
            anchorMin.y /= pixelRect.height;
            anchorMax.x /= pixelRect.width;
            anchorMax.y /= pixelRect.height;

            rect.anchorMin = anchorMin;
            rect.anchorMax = anchorMax;
        }
    }
}