﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public partial class BinaryStorage
    {
        private class ChangeScope : IDisposable
        {
            [NotNull]
            private readonly BinaryStorage _storage;
            private int _counter;
            private bool _disposed;

            public ChangeScope([NotNull] BinaryStorage storage)
            {
                _storage = storage;
                _counter = 1;
            }

            public void Inc()
            {
                _counter++;
            }

            public void Dispose()
            {
                if (_disposed)
                {
                    return;
                }
                _counter--;
                if (_counter != 0)
                {
                    return;
                }
                _disposed = true;
                _storage.SaveDataOnDisk();
            }
        }
    }
}