using System.Threading;
using JetBrains.Annotations;

namespace Magify
{
    /// <summary>
    /// Thread-safe reusable CancellationTokenSource wrapper.
    /// </summary>
    internal class ReusableCancellationTokenSource
    {
        [NotNull]
        private readonly object _lock = new();
        [CanBeNull]
        private CancellationTokenSource _tokenSource;

        public CancellationToken GetOrCreate()
        {
            lock (_lock)
            {
                if (_tokenSource == null || _tokenSource.IsCancellationRequested)
                {
                    _tokenSource = new CancellationTokenSource();
                }
                return _tokenSource.Token;
            }
        }

        public void CancelCurrent()
        {
            lock (_lock)
            {
                ThreadingUtils.CancelAndRemove(ref _tokenSource);
            }
        }
    }
}