using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using UnityEngine.Networking;

namespace Magify
{
    internal partial class ServerApi
    {
        public UniTask<bool> SendTrustedPurchase([NotNull] TrustedPurchaseRecord record, CancellationToken cancellationToken)
        {
            ThrowIfDisposed();
            var config = new RequestConfig(
                WebRequestMethods.SaveTrustedPurchase,
                createSendTrustedPurchaseRequestPayload,
                useWebRequestWithRepeats: false,
                isAuthTokenRequired: true);
            var request = _interactionsProvider.MakeAsyncRequest(
                in _requestSendTrustedPurchaseContext,
                in config,
                cancellationToken);
            return request.HandleByDefault(config, rejectedResult: false);

            WebRequestMessage createSendTrustedPurchaseRequestPayload()
            {
                return CreateSendTrustedPurchaseRequestPayload(record);
            }
        }

        private RepeatState SendTrustedPurchaseResponseHandler(WebResponseMessage response, out bool result)
        {
            _logger.Log($"{nameof(SendTrustedPurchaseResponseHandler)} called");
            if (response.Result == UnityWebRequest.Result.Success)
            {
                result = true;
                return RepeatState.Finish;
            }

            if (!string.IsNullOrEmpty(response.Text))
            {
                var errorResponse = ServerApiUtils.TryExtractErrorResponse(response.Text, _logger);
                if (ServerApiUtils.TryHandleDefaultErrorCodes(errorResponse?.Error, response.RequestMessage.Method, AuthorizationToken, _logger, HandleBannedResponse, out var repeatState))
                {
                    result = false;
                    return repeatState;
                }
            }

            result = false;
            return RepeatState.Finish;
        }

        private WebRequestMessage CreateSendTrustedPurchaseRequestPayload([NotNull] TrustedPurchaseRecord record)
        {
            return new WebRequestMessage()
            {
                Method = WebRequestMethods.SaveTrustedPurchase,
                Payload = record,
            };
        }

        public void CancelAllSendTrustedPurchaseRequests()
        {
            _logger.Log($"{nameof(CancelAllSendTrustedPurchaseRequests)} has been called");
            _requestSendTrustedPurchaseContext.CancelAllRequests();
        }
    }
}