using JetBrains.Annotations;

namespace Magify
{
    public class RestoreStateRequestResponse
    {
        public enum StatusCode
        {
            Success,
            Fail,
            AlreadyHasNewest,
            OnlyForceRestorePossible,
        }

        [CanBeNull]
        public string Result { get; init; }
        [CanBeNull]
        public int? Weight { get; init; }
        public StatusCode Status { get; init; }

        public static RestoreStateRequestResponse Success([NotNull] string result, [NotNull] int? weight)
        {
            return new RestoreStateRequestResponse
            {
                Result = result,
                Weight = weight,
                Status = StatusCode.Success,
            };
        }

        public static RestoreStateRequestResponse Fail()
        {
            return new RestoreStateRequestResponse
            {
                Status = StatusCode.Fail,
            };
        }

        public static RestoreStateRequestResponse AlreadyHasNewest()
        {
            return new RestoreStateRequestResponse
            {
                Status = StatusCode.AlreadyHasNewest,
            };
        }

        public static RestoreStateRequestResponse OnlyForceRestorePossible()
        {
            return new RestoreStateRequestResponse
            {
                Status = StatusCode.OnlyForceRestorePossible,
            };
        }
    }
}