﻿using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal static class ApplicationStateApiMethods
    {
        [NotNull]
        public static string Authorize(RuntimePlatform platform)
        {
            return platform switch
            {
                RuntimePlatform.Android or RuntimePlatform.IPhonePlayer => "authorizeFB",
                _ => throw new UnsupportedPlatformException(),
            };
        }

        [NotNull]
        public static string SaveProgress(RuntimePlatform platform)
        {
            return platform switch
            {
                RuntimePlatform.Android or RuntimePlatform.IPhonePlayer => "saveProgress",
                _ => throw new UnsupportedPlatformException(),
            };
        }

        [NotNull]
        public static string GetProgress(RuntimePlatform platform)
        {
            return platform switch
            {
                RuntimePlatform.Android or RuntimePlatform.IPhonePlayer => "getProgress",
                _ => throw new UnsupportedPlatformException(),
            };
        }
    }
}