using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class Event
    {
        [JsonProperty("id")]
        public string Id { get; set; }

        [JsonProperty("global")]
        [CanBeNull]
        public Positioning Global { get; set; }

        [JsonProperty("session")]
        [CanBeNull]
        public Positioning Session { get; set; }

        [JsonProperty("app_version")]
        [CanBeNull]
        public Positioning Version { get; set; }

        [JsonProperty("daily")]
        [CanBeNull]
        public Positioning Daily { get; set; }

        [JsonProperty("event_in_session")]
        [CanBeNull]
        public SessionPositioning EventInSession { get; set; }

        [JsonProperty("params")]
        [CanBeNull]
        public List<EventParam> Params { get; set; }

        [JsonProperty("global_limit")]
        [CanBeNull]
        public int? GlobalLimit { get; set; }

        [JsonProperty("session_limit")]
        [CanBeNull]
        public int? SessionLimit { get; set; }

        [JsonProperty("daily_limit")]
        [CanBeNull]
        public int? DailyLimit { get; set; }

        [JsonProperty("period_limit")]
        [CanBeNull]
        public int? PeriodLimit { get; set; }

        [JsonProperty("period")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        [CanBeNull]
        public TimeSpan? Period { get; set; }

        [JsonProperty("global_click_limit")]
        [CanBeNull]
        public int? GlobalClickLimit { get; set; }

        [JsonProperty("global_rv_limit")]
        [CanBeNull]
        public int? GlobalRewardLimit { get; set; }

        [JsonProperty("session_rv_limit")]
        [CanBeNull]
        public int? SessionRewardLimit { get; set; }

        [JsonProperty("daily_rv_limit")]
        [CanBeNull]
        public int? DailyRewardLimit { get; set; }

        [JsonProperty("global_bonus_limit")]
        [CanBeNull]
        public int? GlobalBonusLimit { get; set; }

        [JsonProperty("session_bonus_limit")]
        [CanBeNull]
        public int? SessionBonusLimit { get; set; }

        [JsonProperty("daily_bonus_limit")]
        [CanBeNull]
        public int? DailyBonusLimit { get; set; }
    }
}