using JetBrains.Annotations;
using Magify.Types;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class TransactionEvent : IAnalyticsEvent
    {
        [JsonProperty("transaction_id")]
        public string TransactionId { get; init; }

        [JsonProperty("transaction_type")]
        public TransactionType TransactionType { get; init; }

        [JsonProperty("transaction_source"), CanBeNull]
        public string TransactionSource { get; init; }

        [JsonProperty("bonus_type")]
        public string BonusType { get; init; }

        [JsonProperty("group")]
        public string BonusGroup { get; init; }

        [JsonProperty("bonus_value")]
        public int BonusValue { get; init; }

        [JsonProperty("bonus_balance")]
        public int BonusBalance { get; init; }

        [JsonProperty("campaignName"), CanBeNull]
        public string CampaignName { get; init; }

        [JsonProperty("impressionNumber")]
        public int? ImpressionNumber { get; init; }

        [JsonProperty("sessionImpressionNumber")]
        public int? SessionImpressionNumber { get; init; }

        [JsonProperty("campaignTypeImpressionNumber")]
        public int? CampaignTypeImpressionNumber { get; init; }

        [JsonProperty("campaignTypeSessionImpressionNumber")]
        public int? CampaignTypeSessionImpressionNumber { get; init; }

        [JsonProperty("eventName"), CanBeNull]
        public string EventName { get; init; }

        [JsonProperty("eventNumber")]
        public int? EventNumber { get; init; }

        [JsonProperty("sessionEventNumber")]
        public int? SessionEventNumber { get; init; }

        [JsonProperty("sessionNumber")]
        public int? SessionNumber { get; init; }

        [JsonProperty("isDefaultConfig")]
        public bool? IsDefault { get; init; }

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        [JsonProperty("product_id"), CanBeNull]
        public string ProductId { get; init; }

        [JsonProperty("store_name")]
        [CanBeNull]
        public PurchaseStore? StoreName { get; set; }

        [JsonProperty("price"), CanBeNull]
        public string Price { get; init; }

        [JsonProperty("currency"), CanBeNull]
        public string Currency { get; init; }

        [JsonProperty("subscriptionStatus")]
        public SubscriptionStatus SubscriptionStatus { get; init; }

        [JsonProperty("inAppStatus")]
        public InAppStatus InAppStatus { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; init; } = TimestampExtensions.UtcNowTimestamp;

        [JsonProperty("mode"), CanBeNull]
        public string Mode { get; init; }

        [JsonProperty("maxLevel")]
        public int? MaxLevel { get; init; }

        [JsonProperty("level")]
        public int? Level { get; init; }

        [JsonProperty("session_id"), CanBeNull]
        public string SessionId { get; init; }

        [JsonProperty("creative_id"), CanBeNull]
        public string ProductIdCreative { get; init; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("sdk_version"), CanBeNull]
        public string SdkVersion { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public TransactionEvent()
        {
        }

        public TransactionEvent(
            Transaction info,
            BonusInfo bonus,
            int sessionNumber,
            [CanBeNull] CampaignImpression impression,
            [CanBeNull] ProductInfo product,
            SubscriptionStatus subscription,
            InAppStatus inApp,
            LevelStateInfo levelState,
            string sessionId,
            string appVersion,
            string sdkVersion)
        {
            TransactionId = info.Id;
            TransactionType = info.Type;
            TransactionSource = info.Source;

            BonusType = bonus.BonusName;
            BonusGroup = bonus.Group;
            BonusValue = bonus.Quantity;
            BonusBalance = bonus.FinalBalance;

            CampaignName = impression?.CampaignName;
            ImpressionNumber = impression?.ImpressionNumber;
            SessionImpressionNumber = impression?.SessionImpressionNumber;
            CampaignTypeImpressionNumber = impression?.CampaignTypeImpressionNumber;
            CampaignTypeSessionImpressionNumber = impression?.CampaignTypeSessionImpressionNumber;
            EventName = impression?.EventName;
            EventNumber = impression?.EventNumber;
            SessionEventNumber = impression?.SessionEventNumber;
            IsDefault = impression?.IsDefaultConfig;

            SessionNumber = sessionNumber;

            ProductId = product?.ProductId;
            ProductIdCreative = impression?.ProductIdCreative;
            StoreName = product?.Store ?? impression?.StoreName;
            Price = product?.Price;
            Currency = product?.Currency;

            SubscriptionStatus = subscription;
            InAppStatus = inApp;

            Mode = levelState.Mode;
            MaxLevel = levelState.MaxLevel;
            Level = levelState.Level;

            SessionId = sessionId;

            AppVersion = appVersion;
            SdkVersion = sdkVersion;
        }
    }
}