using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class AppBackgroundEvent : IAnalyticsEvent
    {
        [JsonProperty("session_id")]
        public string SessionId { get; init; }

        [JsonProperty("opening_timestamp")]
        public double OpenTimestamp { get; init; }

        [JsonProperty("closing_timestamp")]
        public double CloseTimestamp { get; init; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("sdk_version"), CanBeNull]
        public string SdkVersion { get; init; }

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public AppBackgroundEvent()
        {
        }
    }
}