﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    internal class MinimalCampaignsTracker
    {
        [NotNull]
        private readonly GeneralPrefs _generalPrefs;

        public virtual event Action OnPurchasedProductsChanged;

        public MinimalCampaignsTracker([NotNull] GeneralPrefs generalPrefs)
        {
            _generalPrefs = generalPrefs;
        }

        public virtual void TrackInAppPurchase(string productId, InAppSourceKind sourceKind)
        {
            _generalPrefs.InAppStatus.Value = InAppStatus.Purchased;

            UpdateProductReceiptInfo(productId);
            var isNewProduct = _generalPrefs.PurchasedInAppProducts.Add(productId);
            if (isNewProduct)
            {
                OnPurchasedProductsChanged?.Invoke();
            }
        }

        public virtual void TrackSubscriptionPurchase(string productId, InAppSourceKind sourceKind)
        {
            UpdateProductReceiptInfo(productId);
            var isNewProduct = _generalPrefs.PurchasedSubscriptionProducts.Add(productId);
            if (isNewProduct)
            {
                OnPurchasedProductsChanged?.Invoke();
            }
        }

        protected virtual void UpdateProductReceiptInfo(string productId)
        {
            _generalPrefs.ProductsReceiptTimestamps[productId] = DateTime.UtcNow;
        }
    }
}