#if UNITY_EDITOR || UNITY_ANDROID
using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    internal class AndroidLegacyCountersStorage : IDisposable
    {
        private const string KeyCounters = "counters";

        private readonly BinaryStorage _storage;

        public IDictionary<string, int> Counters { get; }

        public void Dispose()
        {
            _storage?.Dispose();
        }

        [NotNull]
        public static AndroidLegacyCountersStorage Create([NotNull] string storagePath)
        {
            var storage = BinaryStorage
                .Construct(storagePath)
                .AddPrimitiveTypes()
                .SupportDictionariesOf<string, long>()
                .SupportDictionariesOf<string, int>()
                .Build();
            return new AndroidLegacyCountersStorage(storage);
        }

        private AndroidLegacyCountersStorage([NotNull] BinaryStorage storage)
        {
            _storage = storage;

            Counters = _storage.GetDictionary<string, int>(KeyCounters);
        }
    }
}
#endif