using System.Collections.Generic;
using Magify.Model;
using JetBrains.Annotations;

namespace Magify
{
    internal static class EventExtensions
    {
        internal static bool IsSuitable(this Event sourceEvent, Counter<EventsCounterScope> counter, [CanBeNull] IReadOnlyDictionary<string, object> eventParams, int sessionNumber)
        {
            var key = CounterKey.GetKey(source: sourceEvent.Id);

            var fitsEventPosition =
                fitsPosition(sourceEvent.Global, EventsCounterScope.Global) ||
                fitsPosition(sourceEvent.Session, EventsCounterScope.Session) ||
                fitsPosition(sourceEvent.Daily, EventsCounterScope.Daily) ||
                fitsPosition(sourceEvent.Version, EventsCounterScope.Version) ||
                fitsSessionPosition();

            return fitsEventPosition && sourceEvent.MatchParams(eventParams);

            bool fitsPosition([CanBeNull] Positioning position, EventsCounterScope scope)
            {
                var counterValue = counter[scope, key];
                return position != null && position.Contains(counterValue);
            }

            bool fitsSessionPosition()
            {
                var sessionPosition = sourceEvent.EventInSession?.Session?.Contains(sessionNumber) ?? false;
                var eventCounterValue = counter[EventsCounterScope.Session, key];
                var eventInSessionPosition = sourceEvent.EventInSession?.Event?.Contains(eventCounterValue) ?? false;

                return sessionPosition && eventInSessionPosition;
            }
        }

        internal static bool MatchParams([NotNull] this Event sourceEvent, [CanBeNull] IReadOnlyDictionary<string, object> input)
        {
            if (sourceEvent.Params?.Count is null or 0)
                return true;

            if (input == null || input.Count == 0)
                return false;

            return sourceEvent.Params?.TrueForAll(p => p.Match(input)) is true;
        }
    }
}