﻿using System;
using System.Collections.Generic;
using System.Linq;
using JetBrains.Annotations;
using Magify.Model;
using Magify.Rx;
using UnityEngine;

namespace Magify
{
    internal class AssignedAbTests : IContextListener
    {
        [NotNull]
        private static readonly MagifyLogger _logger = MagifyLogger.Get();

        [NotNull]
        private readonly ReactiveProperty<IReadOnlyList<AssignedAbTest>> _values = new(Array.Empty<AssignedAbTest>());
        [NotNull]
        private readonly object _lock = new();

        [NotNull]
        public IReadOnlyReactiveProperty<IReadOnlyList<AssignedAbTest>> Values
        {
            get
            {
                lock (_lock)
                {
                    return _values;
                }
            }
        }

        public ConfigScope SuitableScope => ConfigScope.AbTests;

        public void UpdateContext(CampaignsContext context, ContextKind kind)
        {
            switch (kind)
            {
                case ContextKind.Default:
                    // ignore: might be received only from remote context
                    break;
                case ContextKind.Saved or ContextKind.Downloaded:
                    lock (_lock)
                    {
                        _values.Value = MapTests(context.AssignedAbTests);
                    }
                    break;
            }
        }

        [NotNull]
        private static IReadOnlyList<AssignedAbTest> MapTests([CanBeNull] List<AbTestInfo> tests)
        {
            if (tests == null || tests.Count == 0)
            {
                _logger.Log("Parsed A/B tests list is empty.");
                return Array.Empty<AssignedAbTest>();
            }
            var list = new List<AssignedAbTest>(tests.Count);
            tests.Where(test => test != null)
                .Select(test => new AssignedAbTest
                {
                    Group = test.Group,
                    Name = test.Name,
                })
                .ForEach(item => list.Add(item));
            _logger.Log($"Parsed A/B tests list is: {string.Join('\n', list.Select(t => $"Name: '{t.Name}', Group: '{t.Group}'"))}");
            return list;
        }
    }
}