﻿using System;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal enum ContextKind
    {
        Default,
        Downloaded,
        Saved,
    }

    internal static class ContextKindExtensions
    {
        public static ConfigKind ToConfigKind(this ContextKind contextKind)
        {
            return contextKind switch
            {
                ContextKind.Default => ConfigKind.Default,
                ContextKind.Downloaded => ConfigKind.Downloaded,
                ContextKind.Saved => ConfigKind.Saved,
                _ => throw new ArgumentOutOfRangeException(nameof(contextKind), contextKind, null),
            };
        }
    }

    internal interface IContextListener
    {
        ConfigScope SuitableScope { get; }
        void UpdateContext([NotNull] CampaignsContext context, ContextKind kind);
    }
}