using UnityEngine;

namespace Magify
{
    internal class TextureLocalStorage : LocalStorage<Texture>
    {
        protected override Texture LoadFromStreamingAssets(string url)
        {
            _logger.Log($"{nameof(LoadFromStreamingAssets)} from {url}");
            var bytes = BetterStreamingAssets.ReadAllBytes(url);
            var texture = new Texture2D(2, 2)
            {
                wrapMode = TextureWrapMode.Clamp // Prevents the appearance of artifacts at the edges of the texture
            };
            texture.LoadImage(bytes);
            _logger.Log($"Success load default creative from {url}");
            return texture;
        }

        protected override void ReleaseContent(Texture content)
        {
            Object.Destroy(content);
        }
    }
}