using JetBrains.Annotations;

namespace Magify
{
    public struct PurchaseVerificationResult
    {
        [NotNull]
        public PurchaseRecord Purchase { get; init; }
        public PurchaseVerificationResultCode Code { get; init; }

        [NotNull]
        public string ProductId => Purchase.ProductId;

        public PurchaseVerificationResult([NotNull] PurchaseRecord purchase, PurchaseVerificationResultCode code)
        {
            Purchase = purchase;
            Code = code;
        }

        public static PurchaseVerificationResult Fail([NotNull] PurchaseRecord purchase)
        {
            return new PurchaseVerificationResult(purchase, PurchaseVerificationResultCode.Fail);
        }

        public static PurchaseVerificationResult Cancelled([NotNull] PurchaseRecord purchase)
        {
            return new PurchaseVerificationResult(purchase, PurchaseVerificationResultCode.Cancelled);
        }

        public static PurchaseVerificationResult Success([NotNull] PurchaseRecord purchase)
        {
            return new PurchaseVerificationResult(purchase, PurchaseVerificationResultCode.Success);
        }

        public static PurchaseVerificationResult DoesntSupport([NotNull] PurchaseRecord purchase)
        {
            return new PurchaseVerificationResult(purchase, PurchaseVerificationResultCode.DoesntSupport);
        }

        public static PurchaseVerificationResult Invalid([NotNull] PurchaseRecord purchase)
        {
            return new PurchaseVerificationResult(purchase, PurchaseVerificationResultCode.Invalid);
        }

        public static PurchaseVerificationResult InvalidGoogleCredentials([NotNull] PurchaseRecord purchase)
        {
            return new PurchaseVerificationResult(purchase, PurchaseVerificationResultCode.InvalidGoogleCredentials);
        }
    }
}