using JetBrains.Annotations;
using Newtonsoft.Json;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public class PurchaseRecord
    {
#if UNITY_ANDROID
        [JsonProperty("object_id"), NotNull, Preserve]
#elif UNITY_IOS
        [JsonProperty("product_identifier"), NotNull, Preserve]
#endif
        public string ProductId { get; init; }

        // Android-specific fields
        /// <remarks> Android-specific field. </remarks>
        [JsonProperty("is_subscription"), CanBeNull, Preserve]
        public bool? IsSubscription { get; init; }

        /// <remarks> Android-specific field. </remarks>
        [JsonProperty("transaction_id"), CanBeNull, Preserve]
        public string TransactionId { get; init; }

        /// <remarks> Android-specific field. </remarks>
        [JsonProperty("purchase_token"), CanBeNull, Preserve]
        public string PurchaseToken { get; init; }

        // iOS-specific fields
        /// <remarks> iOS-specific field. </remarks>
        [JsonProperty("receipt_data"), CanBeNull, Preserve]
        public string Receipt { get; init; }

        /// <summary>
        /// Base64 encoded idfv
        /// </summary>
        /// <remarks> iOS-specific field. </remarks>
        [JsonProperty("device_identifier"), CanBeNull, Preserve]
        public string DeviceId { get; init; }

        /// <remarks> iOS-specific field. </remarks>
        [JsonProperty("build_id"), CanBeNull, Preserve]
        public string BuildNumber { get; init; }

        [Preserve]
        public PurchaseRecord()
        {
        }

        [Preserve]
        public PurchaseRecord(PurchaseRecord purchaseRecord)
        {
            ProductId = purchaseRecord.ProductId;

            IsSubscription = purchaseRecord.IsSubscription;
            TransactionId = purchaseRecord.TransactionId;
            PurchaseToken = purchaseRecord.PurchaseToken;

            Receipt = purchaseRecord.Receipt;
            DeviceId = purchaseRecord.DeviceId;
            BuildNumber = purchaseRecord.BuildNumber;
        }
    }
}