using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    public class EditorDevice
    {
        public RuntimePlatform Platform { get; init; }

        [CanBeNull]
        public string DeviceName { get; init; }

        [CanBeNull]
        public string DeviceVersion { get; init; }

        [CanBeNull]
        public Orientation? SupportedOrientation { get; init; }

        [CanBeNull]
        public bool? IsTablet { get; init; }

        [CanBeNull]
        public string Idfa { get; init; }

        [CanBeNull]
        public string Idfv { get; init; }

        [CanBeNull]
        public string GpsAdId { get; init; }

        [CanBeNull]
        public string AndroidId { get; init;  }

        [CanBeNull]
        public string BuildNumber { get; init; }

        public static EditorDevice GetDefaultAndroidDevice() => new()
        {
            Platform = RuntimePlatform.Android,
            DeviceName = "phone-xhdpi",
            DeviceVersion = "30",
            SupportedOrientation = Orientation.Portrait,
            IsTablet = false,
            AndroidId = "00000000-just-f00r-test-000000000000",
            BuildNumber = EditorBuildNumber(RuntimePlatform.Android),
        };

        public static EditorDevice GetDefaultIOSDevice() => new()
        {
            Platform = RuntimePlatform.IPhonePlayer,
            DeviceName = "iPhone10,4",
            DeviceVersion = "16.6.1",
            SupportedOrientation = Orientation.Portrait,
            IsTablet = false,
            BuildNumber = EditorBuildNumber(RuntimePlatform.IPhonePlayer),
        };

        [CanBeNull]
        private static string EditorBuildNumber(RuntimePlatform platform)
        {
#if UNITY_EDITOR
            return platform switch
            {
                RuntimePlatform.Android => UnityEditor.PlayerSettings.Android.bundleVersionCode.ToString(),
                RuntimePlatform.IPhonePlayer => UnityEditor.PlayerSettings.iOS.buildNumber,
                _ => null,
            };
#else
            return null;
#endif
        }
    }
}