﻿namespace Magify
{
    public class CreativeResource
    {
        public enum ArtifactType
        {
            Image = 0,
            Bundle = 1
        }

        public ArtifactType Type { get; init; }
        public string Url { get; init; }

        protected bool Equals(CreativeResource other)
        {
            return Type == other.Type && Url == other.Url;
        }

        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (obj is not CreativeResource other) return false;
            return Equals(other);
        }

        public override int GetHashCode()
        {
            return (Type, Url).GetHashCode();
        }
    }
}