using System;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal abstract class OperatorObservableBase<T> : IObservable<T>
    {
        public IDisposable Subscribe([NotNull] IObserver<T> observer)
        {
            var subscription = new SingleAssignmentDisposable();
            subscription.Disposable = SubscribeCore(observer, subscription);
            return subscription;
        }

        protected abstract IDisposable SubscribeCore([NotNull] IObserver<T> observer, [NotNull] IDisposable cancel);
    }
}