﻿using System;
using JetBrains.Annotations;

namespace Magify.Rx
{
    internal class ListObserver<T> : IObserver<T>
    {
        [NotNull]
        private readonly CopyOnWriteList<IObserver<T>> _observers;

        public ListObserver([NotNull] CopyOnWriteList<IObserver<T>> observers)
        {
            _observers = observers;
        }

        public void OnCompleted()
        {
            var targetObservers = _observers.Data;
            for (var i = 0; i < targetObservers.Length; i++)
            {
                targetObservers[i]?.OnCompleted();
            }
        }

        public void OnError([NotNull] Exception error)
        {
            var targetObservers = _observers.Data;
            for (var i = 0; i < targetObservers.Length; i++)
            {
                targetObservers[i]?.OnError(error);
            }
        }

        public void OnNext(T value)
        {
            var targetObservers = _observers.Data;
            for (var i = 0; i < targetObservers.Length; i++)
            {
                targetObservers[i]?.OnNext(value);
            }
        }

        [NotNull]
        internal IObserver<T> Add([NotNull] IObserver<T> observer)
        {
            return new ListObserver<T>(_observers.Add(observer));
        }

        [NotNull]
        internal IObserver<T> Remove(IObserver<T> observer)
        {
            var i = Array.IndexOf(_observers.Data, observer);
            if (i < 0)
            {
                return this;
            }

            if (_observers.Data.Length == 2)
            {
                return _observers.Data[1 - i]!;
            }
            return new ListObserver<T>(_observers.Remove(observer));
        }
    }
}