﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class CampaignImpression
    {
        private const string ExternalInAppCampaignName = "externalInAppCampaign";
        private const string ExternalInAppEventName = "externalPurchaseEvent";
        private const string ExternalSubscriptionCampaignName = "externalSubscriptionCampaign";
        private const string ExternalSubscriptionEventName = "externalSubscriptionEvent";

        public string CampaignName { get; set; }
        [CanBeNull]
        public bool? IsDefaultConfig { get; set; }
        public int? ImpressionNumber { get; set; }
        public int? SessionImpressionNumber { get; set; }
        public int? CampaignTypeImpressionNumber { get; set; }
        public int? CampaignTypeSessionImpressionNumber { get; set; }

        public string EventName { get; set; }
        public int? EventNumber { get; set; }
        public int? SessionEventNumber { get; set; }
        public int SessionNumber { get; set; }

        [CanBeNull]
        public string ProductId { get; set; }
        [CanBeNull]
        public string ProductIdCreative { get; set; }
        [CanBeNull]
        public PurchaseStore? StoreName { get; set; }

        [CanBeNull]
        public Dictionary<string, object> Parameters { get; set; }

        internal static CampaignImpression CreateBase(int sessionNumber)
        {
            return new CampaignImpression
            {
                CampaignName = string.Intern("baseNoneCampaign"),
                EventName = string.Intern("baseNoneEvent"),
                SessionNumber = sessionNumber,
            };
        }

        internal static CampaignImpression BuildExternalInAppImpression(string productId, int sessionNumber)
        {
            return new CampaignImpression
            {
                CampaignName = ExternalInAppCampaignName,
                EventName = ExternalInAppEventName,
                SessionNumber = sessionNumber,
                ProductId = productId,
            };
        }

        internal static CampaignImpression BuildExternalSubscriptionImpression(string productId, int sessionNumber)
        {
            return new CampaignImpression
            {
                CampaignName = ExternalSubscriptionCampaignName,
                EventName = ExternalSubscriptionEventName,
                SessionNumber = sessionNumber,
                ProductId = productId,
            };
        }
    }
}