using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;

namespace Magify
{
    public interface IAppStateProvider
    {
        /// <summary>
        /// A method where you can prepare and return to the SDK the progress that needs to be saved.
        /// This is an asynchronous method, so you don't have to block the entire execution of the application, all the work of saving progress can be moved to the background. <br/>
        /// Also, remember to use CancellationToken, if you ignore it, the app can do extra work when saving progress has been canceled.
        /// </summary>
        /// <param name="cancellationToken">Will be cancelled if save progress task was cancelld</param>
        /// <returns>
        /// The string that you want to save
        /// </returns>
        UniTask<string> PrepareState(CancellationToken cancellationToken);

        /// <summary>
        /// A method where you can handle the loaded progress.
        /// This is an asynchronous method, so you don't have to block the entire execution of the application, all the work of saving progress can be moved to the background. <br/>
        /// Also, remember to use CancellationToken, if you ignore it, the app can do extra work when saving progress has been canceled.
        /// </summary>
        /// <param name="state">String that was created by application when the last <see cref="PrepareState"/> was called</param>
        /// <param name="weight">The weight that has the progress passed in the `state` parameter</param>
        /// <param name="cancellationToken">Will be cancelled if save progress task was cancelled</param>
        UniTask HandleState([NotNull] string state, [CanBeNull] int? weight, CancellationToken cancellationToken);
    }
}