﻿using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public class AghanimProductCounting
    {
        [JsonProperty("item"), NotNull, Preserve]
        public string ProductId { get; init; }

        [JsonProperty("count"), Preserve]
        public int Count { get; init; }

        public void Deconstruct(out string productId, out int count)
        {
            productId = ProductId;
            count = Count;
        }
    }
}