//
//  MGFMagifyClient.h
//  MagifyNative
//
//  Created by Nikolay Sereda on 18.04.24.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface MGFMagifyClient : NSObject

@property (nonatomic, copy) void (^_Nullable onCloudStoreValueFetched)(NSString *_Nonnull key, NSString *_Nullable value);
@property (nonatomic, copy) void (^_Nullable onApplicationEnterForeground)(void);
@property (nonatomic, copy) void (^_Nullable onApplicationEnterBackground)(void);
@property (nonatomic, copy) void (^_Nullable onApplicationDidBecomeActive)(void);
@property (nonatomic, copy) void (^_Nullable onApplicationWillResignActive)(void);
@property (nonatomic, readonly, copy) NSString *_Nonnull deviceModel;
@property (nonatomic, readonly, copy) NSString *_Nonnull osVersion;
@property (nonatomic, readonly, copy) NSString *_Nonnull buildNumber;
@property (nonatomic) BOOL isTablet;
@property (nonatomic, readonly, copy) NSString *_Nonnull languageWithRegion;
@property (nonatomic, readonly, nullable) NSString *idfa;
@property (nonatomic, readonly, nullable) NSString *idfv;
@property (nonatomic, readonly, nullable) NSString *encodedDeviceIdentifier;
@property (nonatomic, readonly, nullable) NSString *storeCountry;

- (BOOL)isApplicationInstalledForScheme:(NSString *_Nonnull)scheme;
- (void)dispose;
- (NSString *_Nullable)collectMigrationData;
- (void)clearDataAfterMigration;
- (NSString *_Nullable)getStringValueInKeychainForKey:(NSString *_Nonnull)key;
- (void)setStringValueInKeychain:(NSString *_Nonnull)value 
                          forKey:(NSString *_Nonnull)key;
- (void)removeValueInKeychainForKey:(NSString *_Nonnull)key;
- (void)clearKeychains;
- (void)fetchValueFromCloudStoreForKey:(NSString *_Nonnull)key;
- (void)setValueToCloudStore:(NSString *_Nonnull)value
                      forKey:(NSString *_Nonnull)key;
- (void)removeValueFromCloudStoreForKey:(NSString *_Nonnull)key;

@end

NS_ASSUME_NONNULL_END
