﻿using System;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

namespace Magify
{
    public class DefaultLocalizationEditorHelper : ILocalizationEditorHelper
    {
        public string GetCurrentLocale() => "English";

        public string GetLocalizedCacheCharacters(TMP_Text tmpText, bool isUpperOrLowerCase, List<string> availableLocales, bool includeAllLanguages) => string.Empty;

        public Dictionary<string, string> GetLocalizationStringForPreparing(TMP_Text tmp, List<string> availableLocales, bool includeAllLanguages) => new() { [CreativeBuilderConstants.DefaultTextKey] = tmp.text };

        public string GetCharactersForPreparing(TMP_Text tmp, List<string> availableLocales, bool includeAllLanguages) => string.Empty;

        public void RemoveLocalizationScripts(GameObject editingScopePrefabContentsRoot) { }

        public void SetCurrentLocale(string localeCode) { }

        public void LocalizeText(TMP_Text tmpText) { }
    }
}