﻿using System.Threading.Tasks;
using JetBrains.Annotations;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyServiceTests
    {
        public class MagifyServiceTestsPart
        {
            [NotNull]
            protected MagifyService Service => MagifyService.Instance!;

            [SetUp]
            public async Task Setup()
            {
                await Teardown();
                MagifyService.Initialize(new MagifySettings(), new MagifyServiceArgs());
            }

            [TearDown]
            public async Task Teardown()
            {
                if (MagifyService.Instance == null)
                    MagifyService.Initialize(new MagifySettings(), new MagifyServiceArgs());
                (await MagifyService.WaitForInitialized()).Reset();
                MagifyService.Terminate();
            }
        }
    }
}