using JetBrains.Annotations;
using Magify.Model;

namespace Magify.Tests
{
    internal class CampaignModelBuilder
    {
        private readonly CampaignModel _model = new();

        public CampaignModelBuilder WithName(string name)
        {
            _model.Name = name;
            return this;
        }

        public CampaignModelBuilder WithType(CampaignType type)
        {
            _model.Type = type;
            return this;
        }

        public CampaignModelBuilder WithAppVersionLimit([CanBeNull] VersionLimit limit)
        {
            _model.AppVersionLimit = limit;
            return this;
        }

        public CampaignModel Build()
        {
            return _model;
        }
    }
}