﻿using System;
using System.Runtime.Serialization;
using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class EnumExtensionsTests
    {
        private enum TestedEnum
        {
            [EnumMember(Value = "member1")]
            NamedMember1 = 0,
            [EnumMember(Value = "enumMember2")]
            NamedMember2 = 1,
            [EnumMember(Value = "superPuperEnumMember3")]
            NamedMember3 = 2
        }

        [Test]
        [TestCase("member1", TestedEnum.NamedMember1)]
        [TestCase("enumMember2", TestedEnum.NamedMember2)]
        [TestCase("superPuperEnumMember3", TestedEnum.NamedMember3)]
        public void ToEnumMember<T>(string enumMemberName, T expectedValue)
            where T: Enum
        {
            // Act
            var actualValue = enumMemberName.ToEnumMember<T>();

            // Assert
            actualValue.Should().Be(expectedValue);
        }
    }
}