﻿using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class TimestampExtensionsTests
    {
        private const int DigitsInIntPartOfTimestamp = 10;
        private static readonly int[] _possibleDigitsInFloatPartOfTimestamp = {3, 7};

        [Test]
        public void CheckUtcNowTimestampFormat()
        {
            // Arrange
            // Act
            var timestamp = TimestampExtensions.UtcNowTimestamp;

            // Assert
            JsonFacade.SerializeObject(timestamp)
                .Split('.')
                [0].Length
                .Should().Be(DigitsInIntPartOfTimestamp);
            var floatPart = JsonFacade.SerializeObject(timestamp)
                .Split('.')
                [1].Length;
            floatPart.Should().BeGreaterOrEqualTo(0);
            floatPart.Should().BeLessOrEqualTo(3);
        }

        [Test]
        [TestCase(1714025614535)]
        [TestCase(1714025651361)]
        public void TakeMillsWithoutEnd0_ThenCheckTimestampFromLongMillsFormat(long mills)
        {
            // Arrange
            // Act
            var timestamp = mills.TimestampFromLongMills();

            // Assert
            JsonFacade.SerializeObject(timestamp)
                .Split('.')
                [0].Length
                .Should().Be(DigitsInIntPartOfTimestamp);

            var floatPartLength = JsonFacade.SerializeObject(timestamp)
                .Split('.')
                [1].Length;
            _possibleDigitsInFloatPartOfTimestamp.Should().Contain(floatPartLength);
        }

        [Test]
        [TestCase(1714300000000)]
        [TestCase(1714020000000)]
        [TestCase(1714025000000)]
        [TestCase(1714025600000)]
        [TestCase(1714025640000)]
        [TestCase(1714025641000)]
        [TestCase(1714025641300)]
        [TestCase(1714025641330)]
        public void TakeMillsWithEnd0_ThenCheckTimestampFromLongMillsFormat(long mills)
        {
            // Arrange
            // Act
            var timestamp = mills.TimestampFromLongMills();

            // Assert
            JsonFacade.SerializeObject(timestamp)
                .Split('.')
                [0].Length
                .Should().Be(DigitsInIntPartOfTimestamp);

            JsonFacade.SerializeObject(timestamp)
                .Split('.')
                [1].Length
                .Should().BeGreaterOrEqualTo(1);
        }
    }
}