using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class Reset : MagifyClientTestsPart
        {
            [Test]
            public void ResetThereIsNoPersistentFolder()
            {
                using (CreateDefault())
                {
                }
                EditorModeTestsEnvironment.Clear();
                Assert.IsFalse(Directory.Exists(EditorModeTestsEnvironment.RootStoragePath));
            }

            [Test]
            public void Create_Reset_Recreate()
            {
                using (CreateDefault())
                {
                }
                EditorModeTestsEnvironment.Clear();
                using (CreateDefault())
                {
                }
            }

            [Test]
            public void Create_SetAdjustId_Reset()
            {
                const string customAdjustId = "customTestAdjustId";
                Assert.IsTrue(
                    SetClientValue_ResetClient_CheckValueReset(
                        client => client.AdjustId.Value,
                        (client, value) => client.AdjustId.Value = value,
                        customAdjustId));
            }

            [Test]
            public void Create_SetFirebaseInstanceId_Reset()
            {
                const string customFirebaseInstanceId = "customTestFirebaseInstanceId";
                Assert.IsTrue(
                    SetClientValue_ResetClient_CheckValueReset(
                        client => client.FirebaseInstanceId.Value,
                        (client, value) => client.FirebaseInstanceId.Value = value,
                        customFirebaseInstanceId));
            }

            [Test]
            public void Create_SetReferrerId_Reset()
            {
                const string customReferrerId = "customTestReferrerId";
                Assert.IsTrue(
                    SetClientValue_ResetClient_CheckValueReset(
                        client => client.ReferrerId.Value,
                        (client, value) => client.ReferrerId.Value = value,
                        customReferrerId));
            }

            [Test]
            public void Create_SetSubscriptionStatus_Reset()
            {
                foreach (var status in typeof(SubscriptionStatus).GetEnumValues().Cast<SubscriptionStatus>().Where(s => s != GeneralPrefs.DefaultSubscriptionStatus))
                {
                    var isSuccess = SetClientValue_ResetClient_CheckValueReset(
                        client => client.SubscriptionStatus.Value,
                        (client, value) => client.SubscriptionStatus.Value = value,
                        status);
                    if (!isSuccess)
                    {
                        Assert.Fail($"Test failed for {nameof(SubscriptionStatus)} value: {status}");
                    }
                }
            }

            [Test]
            public void Create_SetInAppStatus_Reset()
            {
                foreach (var status in typeof(InAppStatus).GetEnumValues().Cast<InAppStatus>().Where(s => s != GeneralPrefs.DefaultInAppStatus))
                {
                    var isSuccess = SetClientValue_ResetClient_CheckValueReset(
                        client => client.InAppStatus.Value,
                        (client, value) => client.InAppStatus.Value = value,
                        status);
                    if (!isSuccess)
                    {
                        Assert.Fail($"Test failed for {nameof(InAppStatus)} value: {status}");
                    }
                }
            }

            [Test]
            public void Create_SetAuthorizationStatus_Reset()
            {
                foreach (var status in typeof(AuthorizationStatus).GetEnumValues().Cast<AuthorizationStatus>().Where(s => s != GeneralPrefs.DefaultAuthorizationStatus))
                {
                    var isSuccess = SetClientValue_ResetClient_CheckValueReset(
                        client => client.AuthorizationStatus.Value,
                        (client, value) => client.AuthorizationStatus.Value = value,
                        status);
                    if (!isSuccess)
                    {
                        Assert.Fail($"Test failed for {nameof(AuthorizationStatus)} value: {status}");
                    }
                }
            }

            private static bool SetClientValue_ResetClient_CheckValueReset<T>(Func<IMagifyClient, T> getter, Action<IMagifyClient, T> setter, T testCase)
            {
                using (var client = CreateDefault())
                {
                    setter(client, testCase);
                }
                EditorModeTestsEnvironment.Clear();
                using (var client = CreateDefault())
                {
                    return !EqualityComparer<T>.Default.Equals(testCase, getter(client));
                }
            }
        }
    }
}