using System;
using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class Migration : MagifyClientTestsPart
        {
            [Test]
            [TestCase(ClientKind.Full)]
            public void WhenThereIsMigrationData_ThenMigrationSuccessful(ClientKind kind)
            {
                // Arrange
                var clientId = Guid.NewGuid().ToString();
                const string firstVersion = "0.0.1";
                using var magifyClient = CreateDefault(kind);
                var generalPrefs = GetGeneralPrefs(magifyClient);

                // Act
                GetPlatformAPI(magifyClient).CustomMigrationData = new MigrationData
                {
                    ClientId = clientId,
                    FirstInstalledVersion = firstVersion,
                };
                magifyClient.InitializeSdk();

                // Assert
                generalPrefs.ClientId.Value.Should()!.Be(clientId);
                generalPrefs.MigratedUser.Should()!.Be(true);
                generalPrefs.FirstInstalledVersion.Should()!.Be(firstVersion);
            }

            [Test]
            [TestCase(ClientKind.Full)]
            public void WhenThereIsNoMigrationData_ThenMigrationSkipped(ClientKind kind)
            {
                // Arrange
                using var magifyClient = CreateDefault(kind);
                var generalPrefs = GetGeneralPrefs(magifyClient);

                // Act
                magifyClient.InitializeSdk();

                // Assert
                generalPrefs.ClientId.Value.Should()!.NotBeNull();
                generalPrefs.MigratedUser.Should()!.Be(false);
                generalPrefs.FirstInstalledVersion.Should()!.Be(new AppVersionProvider().AppVersion);
            }
        }
    }
}