﻿using System;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    // should be use Interlocked.CompareExchange for Threadsafe?
    // but CompareExchange cause ExecutionEngineException on iOS.
    // AOT...
    // use lock instead

    public sealed class SingleAssignmentDisposable : IDisposable, ICancelable
    {
        [NotNull]
        private readonly object _gate = new();
        [CanBeNull]
        private IDisposable _current;
        private bool _disposed;

        public bool IsDisposed
        {
            get
            {
                lock (_gate)
                {
                    return _disposed;
                }
            }
        }

        public IDisposable Disposable
        {
            get => _current;
            set
            {
                IDisposable old;
                bool alreadyDisposed;
                lock (_gate)
                {
                    alreadyDisposed = _disposed;
                    old = _current;
                    if (!alreadyDisposed)
                    {
                        if (value == null) return;
                        _current = value;
                    }
                }

                if (alreadyDisposed && value != null)
                {
                    value.Dispose();
                    return;
                }

                if (old != null) throw new InvalidOperationException("Disposable is already set");
            }
        }


        public void Dispose()
        {
            IDisposable old = null;

            lock (_gate)
            {
                if (!_disposed)
                {
                    _disposed = true;
                    old = _current;
                    _current = null;
                }
            }

            old?.Dispose();
        }
    }
}