﻿using System;
using System.Collections;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Rx;
using UnityEngine.Pool;

namespace Magify
{
    internal class PooledCompositeDisposable : ICollection<IDisposable>, ICancelable
    {
        [NotNull]
        private static readonly CompositeDisposable _alwaysDisposed;
        [NotNull]
        private CompositeDisposable _inner = GenericPool<CompositeDisposable>.Get() ?? new();

        public int Count => _inner.Count;
        public bool IsReadOnly => _inner.IsReadOnly;
        public bool IsDisposed => _inner.IsDisposed;

        static PooledCompositeDisposable()
        {
            _alwaysDisposed = new(0);
            _alwaysDisposed.Dispose();
        }

        void IDisposable.Dispose() => Release();

        public void Release()
        {
            if (IsDisposed)
            {
                return;
            }
            _inner.Clear();
            GenericPool<CompositeDisposable>.Release(_inner);
            _inner = _alwaysDisposed;
        }

        public IEnumerator<IDisposable> GetEnumerator() => _inner.GetEnumerator();
        IEnumerator IEnumerable.GetEnumerator() => GetEnumerator();
        public void Add(IDisposable item) => _inner.Add(item);
        public void Clear() => _inner.Clear();
        public bool Contains(IDisposable item) => _inner.Contains(item);
        public void CopyTo(IDisposable[] array, int arrayIndex) => _inner.CopyTo(array, arrayIndex);
        public bool Remove(IDisposable item) => _inner.Remove(item);
    }
}