﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using JetBrains.Annotations;

namespace Magify
{
    internal abstract class Section
    {
        public abstract event Action OnChanged;
        public abstract bool HasData { get; }
        [NotNull]
        public abstract string Name { get; }

        public abstract void WriteTo(BinaryWriter writer);
        public abstract void ReadFrom(BinaryReader reader);
        public abstract void Reset();
    }

    internal abstract class Section<TType, TData> : Section
    {
        public override bool HasData => Data.Count > 0;

        [NotNull]
        public BinaryTypeHandler<TType> BinaryType { get; set; }

        [NotNull]
        protected Dictionary<string, TData> Data { get; } = new();

        protected Section([NotNull] BinaryTypeHandler<TType> binaryType)
        {
            BinaryType = binaryType;
        }

        public abstract bool Remove(string key);

        public int Remove([NotNull] Func<string, bool> predicate)
        {
            var keys = Data.Keys.Where(predicate).ToList();
            foreach (var key in keys)
            {
                Remove(key);
            }
            return keys.Count;
        }

        protected (bool Exists, TData Value) TryGet([NotNull] string key)
        {
            return Data.TryGetValue(key, out var value) ? (true, value) : (false, default);
        }
    }
}