using System.Collections.Generic;
using UnityEngine.Networking;
using JetBrains.Annotations;

namespace Magify
{
    public static class ExtensionMethods
    {
        internal static WebResponseMessage ToWebRequestResponse([NotNull] this UnityWebRequest unityWebRequest, WebRequestMessage requestMessage)
        {
            var headers = default(Dictionary<string, string>);
            if (requestMessage.ExpectedHeaders != null)
            {
                headers = new Dictionary<string, string>(requestMessage.ExpectedHeaders.Count);
                foreach (var header in requestMessage.ExpectedHeaders)
                {
                    headers.Add(header, unityWebRequest.GetResponseHeader(header));
                }
            }
            return new WebResponseMessage
            {
                Result = unityWebRequest.result,
                ResponseCode = unityWebRequest.responseCode,
                Text = unityWebRequest.downloadHandler.text,
                Error = unityWebRequest.downloadHandler.error,
                Headers = headers,
                RequestMessage = requestMessage,
            };
        }
    }
}