using System;
using System.Collections.Generic;
using System.Threading;
using Magify.Model;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    internal interface IServerApi : ICancelable
    {
        bool IsOffline { get; }
        [NotNull]
        AuthorizationToken AuthorizationToken { get; }
        [NotNull]
        IReactiveProperty<bool> IsGeoIpEnabled { get; }
        bool ShouldSendLastSyncProgressTime { get; set; }
        bool IsContextRequest { get; }

        void ChangeServerUrl(EndpointUrl url);
        bool RefreshLocale([NotNull] LocaleData localeData);
        void RefreshGpsAdId();
        UniTask CancelAllServerInteractions(bool includeProgress = false);
        UniTask CancelAllContextLoadings();
        void ResetAuthorizationToken();

        [ItemCanBeNull]
        UniTask<string> GetAuthorizationTokenAsync(CancellationToken cancellationToken);
        UniTask<CampaignsContext> GetContextAsync(ConfigScope scopes, CancellationToken cancellationToken);

        UniTask<bool> SendEvents<T>(EventType eventType, [NotNull] IList<T> events, CancellationToken cancellationToken)
            where T : class, IAnalyticsEvent;

        UniTask<PurchaseVerificationResult> VerifyPurchase([NotNull] PurchaseRecord purchaseRecord, bool waitForResult, CancellationToken cancellationToken);
        UniTask<bool> SendTrustedPurchase([NotNull] TrustedPurchaseRecord record, CancellationToken cancellationToken);

        /// <returns>
        /// User Id. Can be null
        /// </returns>
        /// <exception cref="OperationCanceledException"></exception>
        UniTask<string> AuthorizeUser([NotNull] string clientId, CancellationToken cancellationToken);
        /// <exception cref="OperationCanceledException"></exception>
        UniTask<SaveStateRequestResponse> SaveState([NotNull] string appState, [CanBeNull] int? weight, CancellationToken cancellationToken);
        /// <exception cref="OperationCanceledException"></exception>
        UniTask<RestoreStateRequestResponse> RestoreState([CanBeNull] int? weight, CancellationToken cancellationToken);
    }
}