namespace Magify.Model
{
    internal class ErrorResponse
    {
        internal class ErrorInfo
        {
            public ErrorCode Code { get; set; }
            public string Message { get; set; }

            public override string ToString()
            {
                return $"{{ {nameof(Code)}: {Code}; {nameof(Message)}: {Message} }}";
            }
        }

        public ErrorInfo Error { get; set; }
        public string Id { get; set; }
    }

    internal enum ErrorCode
    {
        Expired = 3,
        Banned = 4,
        Revoked = 5,
        AppSupportError = 10,
        InvalidPurchase = 15,
        InvalidGoogleCredentials = 16,
        SyncProgress_SaveConflict = 640,
        SyncProgress_ForceUpdateRequest = 641,
        SyncProgress_AlreadyHasNewest = 642,
        SyncProgress_OnlyForceRestorePossible = 643,
    }
}